'From Squeak3.8 of ''5 May 2005'' [latest update: #6665] on 20 January 2006 at 11:22:15 pm'!
Object subclass: #MPEGFile
	instanceVariableNames: 'pathToFile fileBits fileIndex endianness buffer '
	classVariableNames: 'Registry '
	poolDictionaries: ''
	category: 'Movies-Kernel'!
Object subclass: #MPEGPlayer
	instanceVariableNames: 'external form startTime clockBias frameRate lastDelay noSound sampleRate audioPlayerProcess videoPlayerProcess playerProcessPriority soundQueue timeCheck semaphoreForSound errorForSoundStart morph volume buffer isBuffer '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Movies-Kernel'!

!MPEGFile methodsFor: 'access' stamp: 'JMM 1/20/2006 18:12'!
buffer
	^buffer! !

!MPEGFile methodsFor: 'access' stamp: 'JMM 1/20/2006 23:15'!
isBufferBased
	^(buffer == nil) not ! !

!MPEGFile methodsFor: 'initialize-release' stamp: 'JMM 1/20/2006 18:11'!
openBuffer: aByteArray
	pathToFile := nil.
	buffer _ aByteArray.
	fileBits := self primFileOpenABuffer: aByteArray size: aByteArray size.
	fileBits notNil ifTrue: 
		[fileIndex := Smalltalk registerExternalObject: fileBits.
		self register.]
	! !

!MPEGFile methodsFor: 'primitives' stamp: 'JMM 1/20/2006 17:52'!
primFileOpenABuffer: buffer size: aSize
	"Open the file"
	<primitive: 'primitiveMPEG3OpenABuffer' module: 'Mpeg3Plugin'>
	self primitiveFailed! !


!MPEGFile class methodsFor: 'instance creation' stamp: 'JMM 1/20/2006 18:18'!
openBuffer: aBuffer 
	^self new openBuffer: aBuffer! !

!MPEGFile class methodsFor: 'instance creation' stamp: 'JMM 1/20/2006 23:05'!
openFileUseBuffer: aPath 
	| bar bytes |
	bar _ StandardFileStream oldFileNamed: aPath.
	bar binary.
	bytes _ bar contents.
	^self new openBuffer: bytes! !


!MPEGPlayer methodsFor: 'access' stamp: 'JMM 1/20/2006 18:10'!
external
	[external hasVideo] on: Error do: 
		[self isBuffer
			ifTrue:
			[external := MPEGFile openBuffer: external buffer]
			ifFalse: 
				[(MPEGFile isFileValidMPEG: external fileName) 
					ifFalse: [^self error: 'Mpeg File is invalid'].
				external := MPEGFile openFile: external fileName]].
	^external! !

!MPEGPlayer methodsFor: 'access' stamp: 'JMM 1/20/2006 18:05'!
isBuffer
	^isBuffer == true! !

!MPEGPlayer methodsFor: 'initialize-release' stamp: 'JMM 1/20/2006 18:17'!
initializeWithBuffer: aBuffer form: aForm
	isBuffer := true.
	buffer := aBuffer.
	self initialize: aBuffer.
	self form: aForm.
	^self! !

!MPEGPlayer methodsFor: 'initialize-release' stamp: 'JMM 1/20/2006 18:07'!
initializeWithBuffer: aBuffer morph: aMorphic
	isBuffer _ true.
	buffer _ aBuffer.
	self initialize: aBuffer.
	self morph: aMorphic.
	^self! !

!MPEGPlayer methodsFor: 'initialize-release' stamp: 'JMM 1/20/2006 18:54'!
initialize: aPath

	self halt.
	self isBuffer ifTrue: 
		[external := MPEGFile openBuffer: buffer]
	 ifFalse: 
		[(MPEGFile isFileValidMPEG: aPath) ifFalse: [^nil].
		external := MPEGFile openFile: aPath.].
	self playerProcessPriority: Processor userSchedulingPriority.
	self lastDelay: 10.
	volume := 1.0.
	errorForSoundStart := 500.
	semaphoreForSound := Semaphore new.
	self startTime: (Array new: self totalVideoStreams).
	self clockBias: (Array new: self totalVideoStreams withAll: 0).! !


!MPEGPlayer class methodsFor: 'instance creation' stamp: 'JMM 1/20/2006 18:16'!
playBuffer: aBuffer onForm: aForm
	^self new initializeWithBuffer: aBuffer morph: aForm! !

!MPEGPlayer class methodsFor: 'instance creation' stamp: 'JMM 1/20/2006 18:06'!
playBuffer: aBuffer onMorph: aMorph
	^self new initializeWithBuffer: aBuffer morph: aMorph! !

Object subclass: #MPEGPlayer
	instanceVariableNames: 'external form startTime clockBias frameRate lastDelay noSound sampleRate audioPlayerProcess videoPlayerProcess playerProcessPriority soundQueue timeCheck semaphoreForSound errorForSoundStart morph volume buffer isBuffer'
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Movies-Kernel'!
Object subclass: #MPEGFile
	instanceVariableNames: 'pathToFile fileBits fileIndex endianness buffer'
	classVariableNames: 'Registry'
	poolDictionaries: ''
	category: 'Movies-Kernel'!
